package com.digiwin.athena.semc.controller.mobile;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.mobile.MobileLabelSystemPreQueryReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.service.mobile.MobileLabelSystemPreService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;


/**
 * 移动预设组件
 */
@RestController
@RequestMapping("/semc/mobile/preset/component/")
public class MobileLabelSystemPreController {


    @Resource
    MobileLabelSystemPreService mobileLabelSystemPreService;

    /**
     *  查询移动预设组件列表
     * @param req
     * @return
     */
    @Operation(method = "pageQuery",description = "查询移动预设组件列表")
    @PostMapping("/pageQuery")
    public ResultPageBean pageQuery(@RequestBody @Valid MobileLabelSystemPreQueryReq req){
        return mobileLabelSystemPreService.pageQuery(req);
    }

    /**
     *  查询所有移动预设组件列表
     * @param req
     * @return
     */
    @Operation(method = "queryAll",description = "查询移动预设组件列表")
    @PostMapping("/queryAll")
    public ResponseEntity<BaseResultDTO<List<LabelSystemPre>>> queryAll(@RequestBody  MobileLabelSystemPreQueryReq req){
        return ResponseEntityWrapperUtil.wrapperOk(mobileLabelSystemPreService.getAllSystemPre(req));
    }

}
