package com.digiwin.athena.semc.controller.mobile;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.I18NKey;
import com.digiwin.athena.semc.controller.portal.PortalInfoController;
import com.digiwin.athena.semc.dto.mobile.*;
import com.digiwin.athena.semc.dto.portal.PortalInfoCheckResp;
import com.digiwin.athena.semc.dto.portal.UserPortalInfoRequest;
import com.digiwin.athena.semc.entity.mobile.*;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoUse;
import com.digiwin.athena.semc.mapper.mobile.MobileApplicatonColumnMapper;
import com.digiwin.athena.semc.mapper.mobile.MobileApplicatonColumnNewMapper;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalInfoUseMapper;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalTypeUserMapper;
import com.digiwin.athena.semc.mapper.portal.PortalInfoUseMapper;
import com.digiwin.athena.semc.service.mobile.MobilePortalService;
import com.digiwin.athena.semc.service.mobile.MobileUserAuthService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import com.google.common.collect.Maps;
import com.digiwin.athena.semc.vo.mobile.FullBackResp;
import com.digiwin.athena.semc.vo.mobile.MobileAppColumnResp;
import com.digiwin.athena.semc.vo.mobile.MobilePortalInfoResp;
import com.digiwin.athena.semc.vo.portal.PortalUserAuthResp;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 移动端使用
 */
@Slf4j
@RestController
@RequestMapping("/semc/mobile/portal")
public class MobilePortalAppController {
    private static final Logger logger = LoggerFactory.getLogger(PortalInfoController.class);


    @Autowired
    private MobilePortalService mobilePortalService;

    @Autowired
    private MobilePortalTypeUserMapper mobilePortalTypeUserMapper;

    @Resource
    private MessageUtils messageUtils;

    @Resource
    private MobilePortalInfoUseMapper mobilePortalInfoUseMapper;

    @Resource
    private MobileApplicatonColumnMapper applicatonColumnMapper;

    @Resource
    MobileUserAuthService mobileUserAuthService;

    @Resource
    PortalInfoUseMapper portalInfoUseMapper;

    @Resource
    PortalInfoController portalInfoController;

    @Resource
    private MobileApplicatonColumnNewMapper mobileApplicatonColumnNewMapper;

    /**
     * 查询用户移动门户列表
     *
     * @return
     */
    @Operation(method = "selectUserPortal", summary = "查询用户职能门户列表")
    @PostMapping("/info/userAuth/selectUserPortal")
    public ResponseEntity<BaseResultDTO<List<PortalUserAuthResp>>> selectUserPortal() {
        PortalInfo portalInfo = new PortalInfo();
        portalInfo.setClientType(Constants.ClientTypeEnum.MOBILE.getValue());
        return portalInfoController.selectUserPortal(portalInfo);
//        List<MobilePortalInfoItemResp> result = new ArrayList<>();
//        List<MobilePortalInfoItemResp> mobilePortalInfoItemResps = mobilePortalService.selectUserPortal();
//        if (!CollectionUtils.isEmpty(mobilePortalInfoItemResps)) {
//            result.addAll(mobilePortalInfoItemResps);
//        }
//        return ResponseEntityWrapperUtil.wrapperOk(result);
    }


    /**
     * 查询用户选择门户类型接口
     * 用户最新选择的移动门户类型（0：V1门户、1：新门户）
     *
     * @return
     *//*
    @PostMapping("/getUserPortalType")
    public ResponseEntity<BaseResultDTO<PortalInfoUse>> getUserPortalType() {

        Integer clientType = Constants.ClientTypeEnum.MOBILE.getValue();

        PortalInfoUse result = new PortalInfoUse();
        MobilePortalTypeUse mobilePortalTypeUse = mobilePortalTypeUserMapper
                .selectOne(new LambdaQueryWrapper<MobilePortalTypeUse>()
                        .eq(MobilePortalTypeUse::getCreateUserId, Utils.getUserId()));

        if (ObjectUtils.isEmpty(mobilePortalTypeUse)) {
            result.setPortalType(0);
            return ResponseEntityWrapperUtil.wrapperOk(result);
        }
        if (mobilePortalTypeUse.getPortalType() == 0) {
            // 旧门户
            result.setPortalType(0);
            return ResponseEntityWrapperUtil.wrapperOk(result);
        }
        //查询最近选择的门户
        QueryWrapper<PortalInfoUse> condition = new QueryWrapper<>();
        condition.orderByDesc("id");
        condition.eq("create_user_id", Utils.getUserId());
        condition.eq("client_type", clientType);
        PortalInfoUse usePortal = portalInfoUseMapper.selectOne(condition);
        if (usePortal == null && Constants.ClientTypeEnum.MOBILE.getValue().equals(clientType)) {
            // 兼容移动历史数据
            MobilePortalInfoUse mobilePortalInfoUse =
                    mobilePortalInfoUseMapper.selectOne(new LambdaQueryWrapper<MobilePortalInfoUse>()
                            .eq(MobilePortalInfoUse::getCreateUserId, Utils.getUserId()));
            if (mobilePortalInfoUse != null) {
                usePortal = new PortalInfoUse();
                usePortal.setId(mobilePortalInfoUse.getId());
                usePortal.setTenantId(mobilePortalInfoUse.getTenantId());
                usePortal.setClientType(Constants.ClientTypeEnum.MOBILE.getValue());
                usePortal.setPortalId(mobilePortalInfoUse.getMobilePortalId());
                usePortal.setPortalTypeSource(Constants.PortalTypeSourceEnum.TENANT.getFlag());
            }
        }
        if (usePortal == null) {
            result.setPortalType(0);
            return ResponseEntityWrapperUtil.wrapperOk(result);
        }
        usePortal.setPortalType(1);
        return ResponseEntityWrapperUtil.wrapperOk(usePortal);
    }*/


    /**
     * 获取移动门户详情
     *
     * @return
     */
    @Operation(method = "getPortalInfo", description = "获取门户详情")
    @PostMapping("/info/getPortalInfo")
    public ResponseEntity<?> getPortalInfo(@RequestBody MobilePortalDetailReqDTO req) {
        // 场景：0：正常用户访问、1：预览 ，默认0
        if (req.getScene() == 0) {
            MobilePortalInfoResp mobilePortalInfoResp = mobilePortalService.getPortalInfo(req.getId(), req.getScene());
            //门户布局的判断
            if (null == mobilePortalInfoResp
                    && req.getPortalType().equals(Constants.MobilePortalTypeEnum.PORTAL.getFlag())) {
                mobilePortalInfoResp = new MobilePortalInfoResp();
                String recentlyMsg = messageUtils.getMessage("error.message.not.auth");
                mobilePortalInfoResp.setRecentlyMsg(recentlyMsg);
                return ResponseEntityWrapperUtil.wrapperOk(mobilePortalInfoResp);
            }
            //自定义页面的判断
            if (null == mobilePortalInfoResp && req.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())) {
                String recentlyMsg = messageUtils.getMessage(I18NKey.MOBILE_PORTAL_CUSTOM_DEL);
                return ResponseEntityWrapperUtil.wrapperOk(recentlyMsg);
            }
            //门户未发布
            if (mobilePortalInfoResp.getPortalType().equals(Constants.MobilePortalTypeEnum.PORTAL.getFlag())
                    && mobilePortalInfoResp.getStatus().equals(Constants.ReleaseEnum.NO_RELEASE.getVal())) {
                String recentlyMsg = messageUtils.getMessage("error.message.not.auth");
                mobilePortalInfoResp.setRecentlyMsg(recentlyMsg);
                return ResponseEntityWrapperUtil.wrapperOk(mobilePortalInfoResp);
            }
            //自定义页面-未发布场景 判断
            if (mobilePortalInfoResp.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())
                    && mobilePortalInfoResp.getStatus().equals(Constants.ReleaseEnum.NO_RELEASE.getVal())) {
                String recentlyMsg = messageUtils.getMessage(I18NKey.MOBILE_PORTAL_CUSTOM_DEL);
                return ResponseEntityWrapperUtil.wrapperOk(recentlyMsg);
            }
            try {
                return ResponseEntityWrapperUtil.wrapperOk(mobilePortalService.getPortalDetail(mobilePortalInfoResp));
            } catch (Exception e) {
                log.error("getPortalInfo exception {}", e.getMessage());
                String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/portal/info/getPortalInfo");
                return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
            }
        }

        //门户预览
        MobilePortalInfoResp result = mobilePortalService.getPreMobilePortal(req.getId());

        return ResponseEntityWrapperUtil.wrapperOk(result);
    }


    /**
     * 记录用户选择门户类型接口
     * 用户最新选择的移动门户类型（0：V1门户、1：新门户）
     */
    @PostMapping("/addPortalType")
    public ResponseEntity<BaseResultDTO<Boolean>> addPortalType(@RequestBody MobilePortalTypeUse typeUse) {
        if (ObjectUtils.isEmpty(typeUse.getPortalType())) {
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "未传入相关的参数");
        }
        if (typeUse.getPortalType() == 1 && ObjectUtils.isEmpty(typeUse.getMobilePortalId())) {
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "未传入相关的参数");
        }
        Boolean flag = mobilePortalService.saveMobilePortalTypeUse(typeUse);
        return ResponseEntityWrapperUtil.wrapperOk(flag);
    }

    /**
     * 移动端校验门户权限
     *
     * @param req
     * @return
     */
    @Operation(method = "checkPortalInfo", description = "校验门户权限")
    @PostMapping("/info/checkPortalInfo")
    public ResponseEntity<?> checkPortalInfo(@RequestBody MobilePortalInfo req) {
        if (null == req.getId()) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "id  cannot be empty");
        }
        PortalInfoCheckResp checkResp = new PortalInfoCheckResp();
        checkResp.setIsHavePort(false);
        MobilePortalInfo portalInfo = mobilePortalService.getById(req.getId());
        //门户布局-删除场景 判断
        if (null == portalInfo && req.getPortalType().equals(Constants.MobilePortalTypeEnum.PORTAL.getFlag())) {
            checkResp.setErrorMsg(messageUtils.getMessage(I18NKey.PORTAL_NOT_AUTH));
            return ResponseEntityWrapper.wrapperOk(checkResp);
        }
        //自定义页面的判断
        if (null == portalInfo && req.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())) {
            checkResp.setErrorMsg(messageUtils.getMessage(I18NKey.MOBILE_PORTAL_CUSTOM_DEL));
            return ResponseEntityWrapper.wrapperOk(checkResp);
        }
        checkResp.setPortalName(portalInfo.getName());
        //门户布局-未发布场景 判断
        if (portalInfo.getPortalType().equals(Constants.MobilePortalTypeEnum.PORTAL.getFlag())
                && portalInfo.getStatus().equals(Constants.ReleaseEnum.NO_RELEASE.getVal())) {
            checkResp.setErrorMsg(messageUtils.getMessage(I18NKey.PORTAL_NOT_AUTH));
            return ResponseEntityWrapper.wrapperOk(checkResp);
        }
        //自定义页面-未发布场景 判断
        if (portalInfo.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())
                && portalInfo.getStatus().equals(Constants.ReleaseEnum.NO_RELEASE.getVal())) {
            checkResp.setErrorMsg(messageUtils.getMessage(I18NKey.MOBILE_PORTAL_CUSTOM_DEL));
            return ResponseEntityWrapper.wrapperOk(checkResp);
        }
        //若是默认门户则
        if (portalInfo.getDefaultFlag() == 1) {
            checkResp.setIsHavePort(true);
            return ResponseEntityWrapper.wrapperOk(checkResp);
        }
        try {
            return mobilePortalService.checkPortalInfo(portalInfo);
        } catch (Exception e) {
            log.error("checkPortalInfo exception {}", e.getMessage());
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobilePortal/info/getPortalInfo");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

    /**
     * 保存自定义栏目
     *
     * @param applicationColumnReq
     * @return
     */
    @PostMapping("/saveApplicationColumn")
    public ResponseEntity<?> saveApplicationColumn(@RequestBody @Valid ApplicationColumnReq applicationColumnReq) {
        try {
            mobilePortalService.saveApplicationColumn(applicationColumnReq);
        } catch (Exception e) {
            log.error("saveApplicationColumn error{}", e.getMessage());
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobilePortal/info/saveApplicationColumn");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }

        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 保存自定义栏目默认门户
     *
     * @param applicationColumnReqNew
     * @return
     */
    @PostMapping("/saveApplicationColumnNew")
    public ResponseEntity<?> saveApplicationColumnNew(@RequestBody @Valid ApplicationColumnReqNew applicationColumnReqNew) {
        try {
            mobilePortalService.saveApplicationColumnNew(applicationColumnReqNew);
        } catch (Exception e) {
            log.error("saveApplicationColumnNew error{}", e.getMessage());
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobilePortal/info/saveApplicationColumnNew");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }

        return ResponseEntityWrapper.wrapperOk();
    }


    /**
     * 获取自定义栏目列表
     *
     * @param
     * @return
     */
    @PostMapping("/getApplicationColumnList")
    public ResponseEntity<BaseResultDTO<List<MobileAppColumnResp>>> getApplicationColumnList() {
        try {
            List<MobileAppColumnResp> result = mobilePortalService.getApplicationColumnList();
            if (CollectionUtils.isEmpty(result)) {
                result = new ArrayList<>();
            }
            return ResponseEntityWrapperUtil.wrapperOk(result);
        } catch (Exception e) {
            log.error("getApplicationColumnList error{}", e.getMessage());
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobilePortal/info/getPortalInfo");
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

    /**
     * 获取自定义栏目列表 默认门户(带上应用)
     *
     * @param
     * @return
     */
    @PostMapping("/getApplicationColumnListNew")
    public ResponseEntity<BaseResultDTO<List<MobileAppColumnResp>>> getApplicationColumnListNew() {
        try {
            List<MobileAppColumnResp> result = mobilePortalService.getApplicationColumnListNew();
            if (CollectionUtils.isEmpty(result)) {
                result = new ArrayList<>();
            }
            for (MobileAppColumnResp mobileAppColumnResp : result){
                MobileApplicatonColumnNew mobileApplicatonColumn = new MobileApplicatonColumnNew();
                mobileApplicatonColumn.setId(mobileAppColumnResp.getId());
                MobileAppColumnResp applicationColumnDetail = mobilePortalService.getApplicationColumnDetailNew(mobileApplicatonColumn);
                mobileAppColumnResp.setMobileCustomAppList(applicationColumnDetail.getMobileCustomAppList());

                LambdaQueryWrapper<MobileApplicatonColumnNew> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(MobileApplicatonColumnNew::getCreateUserId,Utils.getUserId()).isNotNull(MobileApplicatonColumnNew::getCustomApplicationId)
                        .eq(MobileApplicatonColumnNew::getParentId,mobileApplicatonColumn.getId());
                List<MobileApplicatonColumnNew> mobileApplicatonColumns = mobileApplicatonColumnNewMapper.selectList(queryWrapper);
                List<Map> ids = new ArrayList<>();
                for (MobileApplicatonColumnNew mobileApplicatonColumnNew : mobileApplicatonColumns){
                    Map map = Maps.newHashMap();
                    map.put("id",mobileApplicatonColumnNew.getCustomApplicationId());
                    map.put("source",mobileApplicatonColumnNew.getSource());
                    map.put("moduleId",mobileApplicatonColumnNew.getModuleId());
                    ids.add(map);
                }
                mobileAppColumnResp.setIdAndSources(ids);
            }
            return ResponseEntityWrapperUtil.wrapperOk(result);
        } catch (Exception e) {
            log.error("getApplicationColumnListNew error{}", e.getMessage());
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobilePortal/info/getApplicationColumnListNew");
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

    /**
     * 获取自定义栏目详情
     *
     * @param applicationColumnReq
     * @return
     */
    @PostMapping("/getApplicationColumnDetail")
    public ResponseEntity<BaseResultDTO<MobileAppColumnResp>> getApplicationColumnDetail(@RequestBody ApplicationColumnReq applicationColumnReq) {
        try {
            if (ObjectUtils.isEmpty(applicationColumnReq.getId())) {
                return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "id  cannot be empty");
            }
            MobileApplicatonColumn mobileApplicatonColumn = applicatonColumnMapper.selectById(applicationColumnReq.getId());
            if (ObjectUtils.isEmpty(mobileApplicatonColumn)) {
                return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, "不存在此自定义栏目");
            }
            MobileAppColumnResp result = mobilePortalService.getApplicationColumnDetail(mobileApplicatonColumn);
            return ResponseEntityWrapperUtil.wrapperOk(result);
        } catch (Exception e) {
            log.error("get application column detail error. param:{}", applicationColumnReq, e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobile/portal/getApplicationColumnDetail:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

    /**
     * 调整自定义栏目的顺序
     *
     * @param columnIds
     * @return
     */
    @PostMapping("/setColumnOrder")
    public ResponseEntity<?> setColumnOrder(@RequestBody List<Long> columnIds) {
        if (CollectionUtils.isEmpty(columnIds)) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "columnIds  cannot be empty");
        }
        try {
            mobilePortalService.setColumnOrder(columnIds);
            return ResponseEntityWrapper.wrapperOk();
        } catch (Exception e) {
            log.error("set column order error. param:{}", columnIds, e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobile/portal/setColumnOrder:" + e.getMessage());
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

    /**
     * 调整自定义栏目的顺序  默认门户
     *
     * @param columnIds
     * @return
     */
    @PostMapping("/setColumnOrderNew")
    public ResponseEntity<?> setColumnOrderNew(@RequestBody List<Long> columnIds) {
        if (CollectionUtils.isEmpty(columnIds)) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "columnIds  cannot be empty");
        }
        try {
            mobilePortalService.setColumnOrderNew(columnIds);
            return ResponseEntityWrapper.wrapperOk();
        } catch (Exception e) {
            log.error("set column order error. param:{}", columnIds, e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobile/portal/setColumnOrder:" + e.getMessage());
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

    /**
     * 获取自定义栏目详情  默认门户
     *
     * @param applicationColumnReq
     * @return
     */
    @PostMapping("/getApplicationColumnDetailNew")
    public ResponseEntity<BaseResultDTO<MobileAppColumnResp>> getApplicationColumnDetailNew(@RequestBody ApplicationColumnReq applicationColumnReq) {
        try {
            if (ObjectUtils.isEmpty(applicationColumnReq.getId())) {
                return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "id  cannot be empty");
            }
            MobileApplicatonColumnNew mobileApplicatonColumn = mobileApplicatonColumnNewMapper.selectById(applicationColumnReq.getId());
            if (ObjectUtils.isEmpty(mobileApplicatonColumn)) {
                return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, "不存在此自定义栏目");
            }
            MobileAppColumnResp result = mobilePortalService.getApplicationColumnDetailNew(mobileApplicatonColumn);
            return ResponseEntityWrapperUtil.wrapperOk(result);
        } catch (Exception e) {
            log.error("get application column detail error. param:{}", applicationColumnReq, e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobile/portal/getApplicationColumnDetail:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

    /**
     * 根据自定义id批量删除栏目
     *
     * @param columnIds
     * @return
     */
    @PostMapping("/delColumn")
    public ResponseEntity<?> delColumn(@RequestBody List<Long> columnIds) {
        if (CollectionUtils.isEmpty(columnIds)) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "columnIds  cannot be empty");
        }
        try {
            mobilePortalService.delColumn(columnIds);
            return ResponseEntityWrapper.wrapperOk();
        } catch (Exception e) {
            log.error("del column error. param:{}", columnIds, e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobile/portal/delColumn:" + e.getMessage());
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

    /**
     * 根据自定义id批量删除栏目   默认门户
     *
     * @param columnIds
     * @return
     */
    @PostMapping("/delColumnNew")
    public ResponseEntity<?> delColumnNew(@RequestBody List<Long> columnIds) {
        if (CollectionUtils.isEmpty(columnIds)) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "columnIds  cannot be empty");
        }
        try {
            mobilePortalService.delColumnNew(columnIds);
            return ResponseEntityWrapper.wrapperOk();
        } catch (Exception e) {
            log.error("del column error. param:{}", columnIds, e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobile/portal/delColumn:" + e.getMessage());
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

    /**
     * 更新栏目状态
     *
     * @param applicationColumnReq
     * @return
     */
    @PostMapping("/updateColumnStatus")
    public ResponseEntity<?> updateColumnStaus(@RequestBody ApplicationColumnReq applicationColumnReq) {
        if (ObjectUtils.isEmpty(applicationColumnReq.getId())) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "id  cannot be empty");
        }
        MobileApplicatonColumn mobileApplicatonColumn = applicatonColumnMapper.selectById(applicationColumnReq.getId());
        if (ObjectUtils.isEmpty(mobileApplicatonColumn)) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, "你所选则的栏目不存在");
        }
        if (ObjectUtils.isEmpty(applicationColumnReq.getStatus())) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "status cannot be empty");
        }
        try {
            mobileApplicatonColumn.setStatus(applicationColumnReq.getStatus());
            applicatonColumnMapper.updateById(mobileApplicatonColumn);
            return ResponseEntityWrapper.wrapperOk();
        } catch (Exception e) {
            log.error("update column status error. param:{}", applicationColumnReq, e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobile/portal/updateColumnStatus:" + e.getMessage());
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

    /**
     * 更新栏目状态  默认门户
     *
     * @param applicationColumnReq
     * @return
     */
    @PostMapping("/updateColumnStatusNew")
    public ResponseEntity<?> updateColumnStausNew(@RequestBody ApplicationColumnReq applicationColumnReq) {
        if (ObjectUtils.isEmpty(applicationColumnReq.getId())) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "id  cannot be empty");
        }
        MobileApplicatonColumnNew mobileApplicatonColumn = mobileApplicatonColumnNewMapper.selectById(applicationColumnReq.getId());
        if (ObjectUtils.isEmpty(mobileApplicatonColumn)) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, "你所选则的栏目不存在");
        }
        if (ObjectUtils.isEmpty(applicationColumnReq.getStatus())) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "status cannot be empty");
        }
        try {
            mobileApplicatonColumn.setStatus(applicationColumnReq.getStatus());
            mobileApplicatonColumnNewMapper.updateById(mobileApplicatonColumn);
            return ResponseEntityWrapper.wrapperOk();
        } catch (Exception e) {
            log.error("update column status error. param:{}", applicationColumnReq, e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobile/portal/updateColumnStausNew:" + e.getMessage());
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

    /**
     * 拼接路径
     *
     * @param mobileSSOReq
     * @return
     */
    @PostMapping("/getFullCallBackUrl")
    public ResponseEntity<BaseResultDTO<FullBackResp>> getFullCallBackUrl(@RequestBody @Valid MobileSSOReq mobileSSOReq) {
        try {
            FullBackResp fullCallBackUrl = mobilePortalService.getFullCallBackUrl(mobileSSOReq);
            if (ObjectUtils.isEmpty(fullCallBackUrl)) {
                return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "你绑定的应用不存在");
            }
            return ResponseEntityWrapperUtil.wrapperOk(fullCallBackUrl);
        } catch (Exception e) {
            log.error("get full callBackUrl error. param:{}", mobileSSOReq, e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobile/portal/getFullCallBackUrl:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

    /**
     * 校验当前用户是否有自定义应用的权限
     *
     * @param validMobileAppAuthDTO 请求入参
     * @return 返回
     */
    @PostMapping("/validUserAppAuth")
    public ResponseEntity<BaseResultDTO<List<ValidMobileAppAuthRespDTO>>> validUserAppAuth(@RequestBody @Valid ValidMobileAppAuthReqDTO validMobileAppAuthDTO) {
        // 校验应用用户权限
        List<Long> applicationIdList = mobileUserAuthService.validUserAppAuth(validMobileAppAuthDTO.getCustomApplicationIdList());
        // 构建返回对象
        List<ValidMobileAppAuthRespDTO> respList = validMobileAppAuthDTO.getCustomApplicationIdList().stream().map(x -> {
            ValidMobileAppAuthRespDTO respDTO = new ValidMobileAppAuthRespDTO();
            respDTO.setCustomApplicationId(x);
            if (applicationIdList.contains(x)) {
                respDTO.setAuthFlag(true);
            }
            return respDTO;
        }).collect(Collectors.toList());
        return ResponseEntityWrapperUtil.wrapperOk(respList);
    }
}
