package com.digiwin.athena.semc.controller.mobile;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.I18NKey;
import com.digiwin.athena.semc.entity.mobile.MobileStartSet;
import com.digiwin.athena.semc.service.mobile.MobileStartSetService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @description App启动配置
 * @author: dengkaiwen
 */
@RestController
@RequestMapping("/semc/mobile/start/set/")
@Slf4j
public class MobileStartSetController {

    @Autowired
    MobileStartSetService mobileStartSetService;

    @Resource
    private MessageUtils messageUtils;


    /**
     * 保存启动页配置
     *
     * @param req
     * @return
     */
    @Operation(method = "saveSet", description = "保存启动页配置")
    @PostMapping("saveSet")
    public ResponseEntity<BaseResultDTO<MobileStartSet>> saveSet(@RequestBody @Valid MobileStartSet req) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk(mobileStartSetService.saveStartSet(req));
        } catch (Exception e) {
            log.error("saveSet exception", e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobile/start/set/saveSet");
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }

    }


    /**
     * 查询租户设置的启动页配置接口
     * web端使用
     * @param req
     * @return
     */
    @Operation(method = "selectStartSetList", description = "查询租户设置的启动页配置接口")
    @PostMapping("selectStartSetList")
    public ResponseEntity<BaseResultDTO<List<MobileStartSet>>> selectStartSetList(@RequestBody MobileStartSet req) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk(mobileStartSetService.selectStartSetList(req.getDeviceType()));
        } catch (Exception e) {
            log.error("selectStartSetList exception", e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobile/start/set/selectStartSetList");
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }


    /**
     * 查询租户设置的启动页配置接口
     * APP使用
     * @return
     */
    @PostMapping("selectAppStartSet")
    public ResponseEntity<BaseResultDTO<List<MobileStartSet>>> selectAppStartSet() {
        try {
            List<MobileStartSet> startSetList=mobileStartSetService.selectStartSetList(null);
            for(MobileStartSet startSet:startSetList){
                //自定义上传
                if(startSet.getImgType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())){
                    startSet.setPicUrl(startSet.getPicLocalUrl());
                }
                //登录用户的语系
                String locale = LocaleContextHolder.getLocale().toString();
                //模板库-繁体
                if(startSet.getImgType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())
                && Constants.ZH_TW_LOCALE.equals(locale)){
                    startSet.setPicUrl(startSet.getPicUrlTw());
                }
                //模板库-简体
                if(startSet.getImgType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())
                        && Constants.ZH_CN_LOCALE.equals(locale)){
                    startSet.setPicUrl(startSet.getPicUrl());
                }
            }
            return ResponseEntityWrapperUtil.wrapperOk(startSetList);
        } catch (Exception e) {
            log.error("selectAppStartSet exception", e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/mobile/start/set/selectAppStartSet");
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

}
