package com.digiwin.athena.semc.controller.module;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.dto.module.ModuleOrderDto;
import com.digiwin.athena.semc.dto.module.SaveModuleOrderReqDto;
import com.digiwin.athena.semc.entity.module.ModuleInfo;
import com.digiwin.athena.semc.service.module.IModuleInfoService;
import com.digiwin.athena.semc.vo.module.ModuleOrderVo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@RestController
@RequestMapping("/semc/moduleOrder")
@Slf4j
@RequiredArgsConstructor
public class ModuleOrderController {

    @Resource
    private IModuleInfoService moduleInfoService;

    /**
     * 根据模组名称查询模组列表
     *
     * @param moduleCode 模组代号
     * @return 查询结果
     */
    @GetMapping("/query")
    public ResponseEntity<?> query(@RequestParam String moduleCode) {
        List<ModuleOrderVo> result = moduleInfoService.queryModuleOrder(moduleCode);
        return ResponseEntityWrapper.wrapperOk(result);
    }

    /**
     * 模组顺序立即生效
     * @param
     * @return 查询结果
     */
    @PostMapping("/save")
    public ResponseEntity<?> save(@RequestBody SaveModuleOrderReqDto req) {
        String moduleCode = req.getModuleCode();
        List<ModuleOrderVo> moduleOrderVoList = req.getData();
        Integer result = moduleInfoService.saveModuleOrder(moduleOrderVoList, moduleCode);
        return ResponseEntityWrapper.wrapperOk(result);
    }

    /**
     * 根据模组名称恢复默认
     * @param
     * @return 查询结果
     */
    @PostMapping("/del")
    public ResponseEntity<?> del(@RequestBody SaveModuleOrderReqDto req) {
        List<ModuleOrderVo> result = moduleInfoService.delModuleOrder(req.getModuleCode());
        return ResponseEntityWrapper.wrapperOk(result);
    }

    /**
     * 根据模组名称查询当前租户顺序
     * @return 查询结果
     */
    @GetMapping("/queryTenant")
    public ResponseEntity<?> queryTenant(@RequestParam String moduleCode) {
        return ResponseEntityWrapper.wrapperOk(moduleInfoService.queryTenantModuleOrder(moduleCode));
    }
}
