package com.digiwin.athena.semc.controller.news;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.I18NKey;
import com.digiwin.athena.semc.dto.news.SaveNewsAuthReq;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;

import javax.annotation.Resource;
import javax.validation.Valid;

import lombok.extern.slf4j.Slf4j;

/**
 * 新闻公告权限表(TNewsAnnouncementAuth)表控制层
 *
 * @author sungqz
 * @since 2024-05-14
 */
@Slf4j
@RestController
@RequestMapping("/semc/news/auth")
public class NewsAnnouncementAuthController {

    @Resource
    private MessageUtils messageUtils;

    /**
     * 保存公告的权限（暂时不用）
     *
     *
     * @param saveNewsAuthReq 入参
     * @return 返回
     */
    @PostMapping("/saveNewsAuth")
    public ResponseEntity<BaseResultDTO<Boolean>> saveNewsAuth(@RequestBody @Valid SaveNewsAuthReq saveNewsAuthReq) {
        try {
           // newsAnnouncementAuthService.saveNewsAuth(saveNewsAuthReq);
            return ResponseEntityWrapperUtil.wrapperOk(true);
        } catch (Exception e) {
            log.error("save news auth error. param:{}", saveNewsAuthReq, e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/news/auth/saveNewsAuth, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

    /**
     * 删除公告的权限（暂时不用）
     *
     * @param id 权限主键id
     * @return 返回
     */
    @GetMapping("/delNewsAuth")
    public ResponseEntity<BaseResultDTO<Boolean>> delNewsAuth(@RequestParam Long id) {
        try {
           // newsAnnouncementAuthService.getBaseMapper().deleteById(id);
            return ResponseEntityWrapperUtil.wrapperOk(true);
        } catch (Exception e) {
            log.error("del news auth error. id:{}", id, e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/news/auth/delNewsAuth, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }
}

