package com.digiwin.athena.semc.controller.news;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.news.QueryNewsListPageReq;
import com.digiwin.athena.semc.entity.news.NewsAnnouncement;
import com.digiwin.athena.semc.service.news.NewsAnnouncementService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;

/**
 * 公告-管理后台接口
 *
 * @author sunqgz
 * @since 2024-11-19
 */
@Slf4j
@RestController
@RequestMapping("/semc/backend/news")
public class NewsAnnouncementBackendController {

    /**
     * 服务对象
     */
    @Resource
    private NewsAnnouncementService newsAnnouncementService;

    /**
     * 查询当前租户移动端公告列表
     *
     * @return 查询结果
     */
    @PostMapping("/queryNewsListByCondition")
    public ResponseEntity<BaseResultDTO<List<NewsAnnouncement>>> queryNewsListByCondition(@RequestBody  QueryNewsListPageReq queryNewsListPageReq) {
        //默认查询移动端的和全部的渠道公告
        if(CollectionUtils.isEmpty(queryNewsListPageReq.getNewsChannelList())){
            List<Integer> newsChannelList=new ArrayList<>();
            newsChannelList.add(Constants.NewsChannelFlagEnum.ALL.getFlag());
            newsChannelList.add(Constants.NewsChannelFlagEnum.MOBILE.getFlag());
            queryNewsListPageReq.setNewsChannelList(newsChannelList);
        }
        //只查询一方公告
        queryNewsListPageReq.setNewsSource(Constants.NewsSourceEnum.ONE.getFlag());
        List<NewsAnnouncement> newsAnnouncementList = newsAnnouncementService.queryNewsListByCondition(queryNewsListPageReq);
        return ResponseEntityWrapperUtil.wrapperOk(newsAnnouncementList);
    }
}