package com.digiwin.athena.semc.controller.news;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.semc.dto.news.SaveNewsTypeAuthReq;
import com.digiwin.athena.semc.service.news.NewsAnnouncementTypeAuthService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.news.NewsTypeAuthVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * 公告类型权限表  表控制层
 *
 * @author sunqgz
 * @since 2025-01-10
 */
@Slf4j
@RestController
@RequestMapping("/semc/news/type/auth")
public class NewsAnnouncementTypeAuthController {
    /**
     * 服务对象
     */
    @Resource
    private NewsAnnouncementTypeAuthService newsAnnouncementTypeAuthService;

    /**
     * 管理后台-查询权限对象关联的公告类型列表
     *
     * @return 查询结果
     */
    @GetMapping("/queryAuthNewsTypeList")
    public ResponseEntity<BaseResultDTO<NewsTypeAuthVO>> queryAuthNewsTypeList(@RequestParam(value = "authId") String authId) {
        NewsTypeAuthVO newsTypeAuthVO = newsAnnouncementTypeAuthService.queryAuthRelNewsType(authId);
        return ResponseEntityWrapperUtil.wrapperOk(newsTypeAuthVO);
    }

    /**
     * 管理后台-保存权限对象关联的公告类型
     *
     * @return 查询结果
     */
    @PostMapping("/saveNewsTypeAuth")
    public ResponseEntity<BaseResultDTO<Boolean>> saveNewsTypeAuth(@RequestBody @Valid SaveNewsTypeAuthReq saveNewsTypeAuthReq) {
        newsAnnouncementTypeAuthService.saveNewsTypeAuth(saveNewsTypeAuthReq);
        return ResponseEntityWrapperUtil.wrapperOk(true);
    }
}

