package com.digiwin.athena.semc.controller.news;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.I18NKey;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.dto.news.ThirdNewsAnnouncementReq;
import com.digiwin.athena.semc.dto.news.ThirdNewsReq;
import com.digiwin.athena.semc.service.news.ThirdNewsAnnouncementService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.List;

import javax.annotation.Resource;
import javax.validation.Valid;

import io.vavr.Tuple3;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@RestController
@RequestMapping("/semc/third/news")
public class ThirdNewsAnnouncementController {


    @Resource
    private MessageUtils messageUtils;

    @Autowired
    private ThirdNewsAnnouncementService thirdNewsAnnouncementService;

    /**
     * 三方系统推送公告_
     *
     * @param thirdNewsReq
     * @return
     */
    @PostMapping("/receive")
    public ResponseEntity<BaseResultDTO<Boolean>> receiveNewsList(@RequestBody @Valid ThirdNewsReq thirdNewsReq) {
        try {
            log.info("receive message. param:{}", JSON.toJSONString(thirdNewsReq));
            // 判断当前应用是否存在
            Tuple3<String, String, ApplicationTypeEnum> tuple3 = thirdNewsAnnouncementService.checkAppCode(thirdNewsReq.getAppId(), thirdNewsReq.getAppCode());
            String error = tuple3._1;
            String tenantId = tuple3._2;
            if (StringUtils.isNotBlank(error) || StringUtils.isBlank(tenantId)) {
                return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
            }
            List<ThirdNewsAnnouncementReq> thirdNewsAnnouncementReqs = thirdNewsReq.getThirdNewsAnnouncementReqs();
            // 校验时间格式
            String errorMsg = thirdNewsAnnouncementService.checkNewsDateIsValid(thirdNewsAnnouncementReqs);
            if (StringUtils.isNotBlank(errorMsg)) {
                return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, errorMsg);
            }
            thirdNewsAnnouncementService.saveNewsList(thirdNewsAnnouncementReqs,thirdNewsReq.getAppId(),thirdNewsReq.getAppCode(),tenantId,tuple3._3);
            return ResponseEntityWrapperUtil.wrapperOk(true);
        } catch (Exception e) {
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/third/news/receive, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, e.getMessage());
        }
    }
}
