package com.digiwin.athena.semc.controller.open;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.I18NKey;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.controller.BasicController;
import com.digiwin.athena.semc.dto.message.*;
import com.digiwin.athena.semc.entity.message.ThirdMessageConfig;
import com.digiwin.athena.semc.entity.message.ThirdMessageInfo;
import com.digiwin.athena.semc.service.message.ThirdSystemMessageService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.time.LocalDateTime;

/**
 * @author sungqz
 * @Description 三方异构系统消息接入
 * createDate: 2024/3/4
 */
@Slf4j
@RestController
@RequestMapping("/semc/openapi/message")
public class ThirdMessageController extends BasicController<ThirdSystemMessageService, ThirdMessageConfig> {

    @Resource
    private ThirdSystemMessageService thirdSystemMessageService;

    @Resource
    private MessageUtils messageUtils;

    /**
     * 查询消息的未读数量，在首页小铃铛展示
     *
     * @return 返回
     */
    @PostMapping("/queryUnreadCount")
    public ResponseEntity<BaseResultDTO<Long>> queryUnreadCount() {
        try {
            return ResponseEntityWrapperUtil.wrapperOk(thirdSystemMessageService.queryUnreadCount(0));
        } catch (Exception e) {
            log.error("query unread count error", e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/openapi/message/queryUnreadCount");
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

    /**
     * 分页查询消息列表
     *
     * @return 返回
     */
    @PostMapping("/list")
    public ResponseEntity<BaseResultDTO<PageInfoResp<ThirdMessageInfo>>> queryMessageListPage(@RequestBody @Valid QueryThirdMessageListReq queryThirdMessageListReq) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk(thirdSystemMessageService.queryMessageListPage(queryThirdMessageListReq));
        } catch (Exception e) {
            log.error("query message list page error", e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/openapi/message/list");
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

    /**
     * 读取消息，记录为已读消息
     *
     * @return 返回
     */
    @PostMapping("/readMessage")
    public ResponseEntity<BaseResultDTO<Boolean>> readMessage(@RequestBody ReadThirdMessageReq readThirdMessageReq) {
        try {
            thirdSystemMessageService.readMessage(readThirdMessageReq);
            return ResponseEntityWrapperUtil.wrapperOk(true);
        } catch (Exception e) {
            log.error("read message list error. readThirdMessageReq:{}", readThirdMessageReq, e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/openapi/message/readMessage");
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
    }

}
