package com.digiwin.athena.semc.controller.portal;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.service.portal.LabelSystemCountService;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 数据源自定义统计组件控制层
 *
 * @author ffy
 */
@RestController
@RequestMapping("/semc/count/component")
@CrossOrigin("*")
@Slf4j
public class LabelSystemCountController {

    @Resource
    LabelSystemCountService labelSystemCountService;

    @Autowired
    private LabelSystemDataService labelSystemDataService;

    /**
     * 获取统计组件第三方的统计类型配置
     *
     * @param labelSystemData 请求参数
     * @return 返回
     */
    @PostMapping("/queryCountConfigList")
    public ResponseEntity<BaseResultDTO<JSONArray>> queryCountConfigList(@RequestBody LabelSystemData labelSystemData) {
        // 校验
        if (!Constants.COUNT_COMPOENT_TYPE.equals(labelSystemData.getDataCategory())) {
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "dataCategory is illegal:" + labelSystemData.getDataCategory());
        }
        // 混合云
        if (Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(labelSystemData.getDataModel())
                && (StringUtils.isBlank(labelSystemData.getMiddleSystemUid()) || StringUtils.isBlank(labelSystemData.getMiddleSystemName()))) {
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.PARAM_MISSING_ERROR, "param is missing");
        }
        // 非混合云
        if (Constants.DataModelEnum.MODEL_CLOUD.getVal().equals(labelSystemData.getDataModel()) && StringUtils.isBlank(labelSystemData.getRestUrl())) {
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.PARAM_MISSING_ERROR, "param is missing");
        }

        // 查询
        JSONArray jsonArray = labelSystemCountService.queryCountConfigData(labelSystemData);
        return ResponseEntityWrapperUtil.wrapperOk(jsonArray);
    }

    /**
     * 获取三方应用统计类型指标数据--前端可视化查询接口
     *
     * @param param 参数
     * @return 返回
     */
    @PostMapping("/queryCountMetricList")
    public ResponseEntity<?> queryCountContentList(@RequestBody Map<String, Object> param) {
        // 校验
        if (MapUtils.isEmpty(param) || ObjectUtils.isEmpty(param.get("id"))) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.PARAM_MISSING_ERROR, "param is missing");
        }
        // 根据自定义组件id查询配置的数据源
        List<LabelSystemData> systemDataList = labelSystemDataService.querySystemDataBySystemId(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal(), Collections.singletonList(Long.valueOf(param.get("id").toString())), Utils.getTenantId());
        if (CollectionUtils.isEmpty(systemDataList)) {
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.PARAM_ILLEGAL_ERROR, "the data source is not exist, systemId:" + param.get("id"));
        }
        LabelSystemData systemData = systemDataList.get(0);
        log.info("query count metric list | query label system data result:{}", systemData);

        // 查询
        Map<String, Object> frontList = labelSystemCountService.queryCountContentDataByConfig(systemData);
        if (frontList.isEmpty()) {
            return ResponseEntityWrapper.wrapperOk(new JSONArray());
        }
        return ResponseEntityWrapper.wrapperOk(frontList);
    }
}
