package com.digiwin.athena.semc.controller.portal;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataSourceUpdateReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreQueryReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemUpdateValidReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemPreCustomVo;
import com.digiwin.athena.semc.vo.portal.ValidLabelRelVO;
import io.swagger.v3.oas.annotations.Operation;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;


/**
 * @author CR-7
 * create: 2024-01-23 15:29
 * Description: 预设组件
 */
@RestController
@RequestMapping("/semc/preset/component")
public class LabelSystemPreController {


    @Resource
    LabelSystemPreService labelSystemPreService;


    @Resource
    private MessageUtils messageUtils;


    /**
     *  查询预设组件列表
     * @param labelSystemPreQueryReq
     * @return
     */
    @Operation(method = "pageQuery",description = "查询预设组件列表")
    @PostMapping("/pageQuery")
    public ResultPageBean pageQuery(@RequestBody @Valid LabelSystemPreQueryReq labelSystemPreQueryReq){
        return labelSystemPreService.pageQuery(labelSystemPreQueryReq);
    }


    /**
     *  更新组件数据源
     * @param labelSystemUpdateReq
     * @return
     */
    @Operation(method = "updateDataSource",description = "更新组件数据源")
    @PostMapping("/updateDataSource")
    public ResponseEntity<?> updateDataSource(@RequestBody @Valid LabelSystemDataSourceUpdateReq labelSystemUpdateReq){

        if(CollectionUtils.isEmpty(labelSystemUpdateReq.getDataSourceInfo())){
            String error = messageUtils.getMessage("error.message.system.data.source.empty");
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, error);
        }
        return labelSystemPreService.updateDataSource(labelSystemUpdateReq);
    }

    /**
     * 校验自定义组件是否关联门户、菜单、作业工作台
     *
     * @param labelSystemUpdateValidReq 请求入参
     * @return 返回
     */
    @PostMapping("/validLabelRel")
    public ResponseEntity<?> validLabelRel(@RequestBody @Valid LabelSystemUpdateValidReq labelSystemUpdateValidReq){
        ValidLabelRelVO validLabelRelVO = labelSystemPreService.validLabelRel(labelSystemUpdateValidReq);
        return ResponseEntityWrapperUtil.wrapperOk(validLabelRelVO);
    }

    /**
     *  更新启用停用状态
     * @param labelSystemUpdateValidReq
     * @return
     */
    @Operation(method = "updateValidStatus",description = "更新启用停用状态")
    @PostMapping("/updateValidStatus")
    public ResponseEntity<?> updateValidStatus(@RequestBody @Valid LabelSystemUpdateValidReq labelSystemUpdateValidReq){
        return labelSystemPreService.updateValidStatus(labelSystemUpdateValidReq.getId(),
                labelSystemUpdateValidReq.getValidStatus(),labelSystemUpdateValidReq.getComponentSource(),labelSystemUpdateValidReq.getClientType());
    }


    /**
     * 查询预设组件和自定义组件列表
     * @param req 请求入参
     * @return 返回
     */
    @Operation(method = "queryAllSystem",description = "查询预设组件和自定义组件列表")
    @PostMapping("/queryAllSystem")
    public ResponseEntity<BaseResultDTO<LabelSystemPreCustomVo>> queryAllSystem(@RequestBody LabelSystemAllVo req){
        return ResponseEntityWrapperUtil.wrapperOk(labelSystemPreService.queryAllSystem(req));
    }

    /**
     * 根据条件查询预设组件和自定义组件列表
     * @param req 请求入参
     * @return 返回
     */
    @PostMapping("/queryAllSystemLabel")
    public ResponseEntity<BaseResultDTO<LabelSystemPreCustomVo>> queryAllSystemLabel(@RequestBody LabelSystemAllVo req){
        return ResponseEntityWrapperUtil.wrapperOk(labelSystemPreService.queryAllSystemLabel(req));
    }

    /**
     *  修改预设组件待办数据和数据源关联关系
     * @return
     */
    @PostMapping("/editToDoData")
    public ResponseEntity<BaseResultDTO<Integer>> editToDoData(@RequestBody LabelSystemPre req){
        return ResponseEntityWrapperUtil.wrapperOk(labelSystemPreService.editToDoData(req));
    }
}
