package com.digiwin.athena.semc.controller.portal;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.entity.portal.PortalCountDay;
import com.digiwin.athena.semc.service.portal.PortalCountDayService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import javax.validation.Valid;

/**
 * @description 用户使用门户行为记录/统计
 * @author: dengkaiwen
 */
@RestController
@RequestMapping("/semc/portal/count")
@Slf4j
public class PortalCountController {


    @Autowired
    PortalCountDayService portalCountDayService;


    /**
     * 记录用户门户行为接口
     *
     * @param req 请求实体
     * @return
     * @throws Exception
     */
    @Operation(summary = "记录用户门户行为接口")
    @PostMapping("/addUserRecord")
    public ResponseEntity<?> addUserRecord(@RequestBody @Valid PortalCountDay req) {
        try {
            portalCountDayService.addUserRecord(req);
            return ResponseEntityWrapper.wrapperOk();
        } catch (Exception e) {
            log.error("addUserRecord exception", e);
            return ResponseEntityWrapper.wrapperOk();
        }
    }




}
