package com.digiwin.athena.semc.controller.portal;

import com.digiwin.athena.semc.common.ResultBean;
import com.digiwin.athena.semc.dto.portal.PortalLayoutCustomReq;
import com.digiwin.athena.semc.service.portal.PortalLayoutCustomService;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;


/**
 * @author CR-7
 * create: 2024-01-25 15:46
 * Description: 极简门户布局
 */
@RestController
@RequestMapping("/semc/portal/layout")
public class PortalLayoutCustomController {


    @Resource
    PortalLayoutCustomService portalLayoutCustomService;

    /**
     *  查询门户布局
     * @return
     */
    @Operation(method = "queryPortalLayout",description = "查询门户布局")
    @PostMapping("/queryPortalLayout")
    public ResultBean queryPortalLayout() {
        return portalLayoutCustomService.queryPortalLayout();
    }


    /**
     *  保存组件
     * @param portalLayoutCustomReq
     * @return
     */
    @Operation(method = "save",description = "保存组件")
    @PostMapping("/save")
    public ResponseEntity<?> save(@RequestBody @Valid PortalLayoutCustomReq portalLayoutCustomReq) {
        return portalLayoutCustomService.save(portalLayoutCustomReq);
    }


    /**
     *  删除组件
     * @param id
     * @return
     */
    @Operation(method = "delete",description = "删除组件")
    @PostMapping("/delete")
    public ResponseEntity<?> delete(@RequestParam("id") Long id) {
        return portalLayoutCustomService.delete(id);
    }
}
