package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.*;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.controller.BasicController;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreReq;
import com.digiwin.athena.semc.dto.portal.ReportPageQueryReq;
import com.digiwin.athena.semc.entity.portal.Report;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.service.portal.ReportService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 报表(Report)表控制层
 *
 * @author sunyfa
 * @since 2022-12-06 10:53:03
 */
@Slf4j
@RestController
@RequestMapping("/semc/report")
public class ReportController extends BasicController<ReportService, Report> {
    @Resource
    private ESPService espService;

    @Resource
    private MessageUtils messageUtils;

    @Resource
    private ReportService reportService;
    /**
     * 分页查询报表
     *
     * @param reportPageQueryReq  查询报表请求参数
     * @return
     */
    @PostMapping("/pageQuery")
    public ResultPageBean pageQueryReport(@Valid @RequestBody ReportPageQueryReq reportPageQueryReq) {
        log.info("Query report by page param: reportPageQueryReq:{}", JSON.toJSONString(reportPageQueryReq));

        ResultPageBean resultPageBean;
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        try {
            ReportPageQueryReq.EaiSysInfo eaiSysInfo = reportPageQueryReq.getEaiSysInfoList().get(0);
            // 通过 EAI 调用三方接口获取报表数据
            Map<String, Object> result = espService.queryByEsp(eaiSysInfo.getEaiSysName(), eaiSysInfo.getEaiSysUid(),
                    EAIServiceNameEnum.REPORT.getServiceName(), null, null, reportPageQueryReq.getQryCondition(),
                    PageInfo.getPageInfo(reportPageQueryReq.getPageNum(), reportPageQueryReq.getPageSize()));

            if (Objects.nonNull(result.get("report_info_list"))) {
                Integer totalResults = Integer.parseInt(result.get("total_results").toString());

                JSONArray array = JSONArray.fromObject(result.get("report_info_list"));
                List<net.sf.json.JSONObject> list = Lists.newArrayList();
                for (int i = 0; i < array.size(); i++) {
                    net.sf.json.JSONObject jsonObject = array.getJSONObject(i);
                    String reportUrl = jsonObject.getString("report_url");
                    jsonObject.put("report_url", reportUrl + (reportUrl.contains("?") ? "&" : "?") + "appToken=" + eaiSysInfo.getAppToken() + "&tenantId=" + tenantId + "&bindMode=" + eaiSysInfo.getUserBindFlag());
                    list.add(jsonObject);
                }
                resultPageBean = ResultPageBean.success(ResponseBody.getInstance(list, PageInfo.getPageInfo(reportPageQueryReq.getPageNum(), reportPageQueryReq.getPageSize(), totalResults)));
            } else {
                resultPageBean = ResultPageBean.success(null);
            }
        } catch (BizException bizException) {
            return ResultPageBean.bizException(BizException.getDefaultBizException(ErrorCodeConstant.ADAPT_SYSTEM_ERROR,
                    messageUtils.getMessage(I18NKey.REPORT_OPEN_ERROR)));
        } catch (Exception e) {
            log.error("Report qryReport exception", e);
            resultPageBean = ResultPageBean.sysException(new ServiceException(ErrorCodeConstant.SYSTEM_ERROR,
                    messageUtils.getMessage(I18NKey.COMMON_SYSTEM_ERROR)));
        }

        return resultPageBean;
    }


    /**
     * 分页查询三方报表
     *
     * @param reportPageQueryReq  查询报表请求参数
     * @return
     */
    @PostMapping("/label/pageQueryReport")
    public ResultPageBean pageQueryLabelReport(@Valid @RequestBody LabelSystemPreReq reportPageQueryReq) {
        log.info("/label/pageQueryLabelReport Req:{}", JSON.toJSONString(reportPageQueryReq));
        ResultPageBean resultPageBean;
        try {
             resultPageBean=reportService.pageQueryReport(reportPageQueryReq);
        } catch (Exception e) {
            log.error("pageQueryLabelReport exception", e);
            String error = String.format(messageUtils.getMessage(I18NKey.SYSTEM_ERROR), LocalDateTime.now(), "/semc/report/label/pageQueryReport");
            resultPageBean = ResultPageBean.sysException(new ServiceException(ErrorCodeConstant.SYSTEM_ERROR,
                    error));
        }
        return resultPageBean;
    }
}
