package com.digiwin.athena.semc.controller.portal;

import com.digiwin.athena.semc.dto.portal.NoticeReq;
import com.digiwin.athena.semc.service.portal.TodoNoticeService;
import com.digiwin.athena.semc.vo.portal.NoticeVO;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author CR-7
 * create: 2024-03-25 16:22
 * Description: 非混合云
 */
@Slf4j
@RestController
@RequestMapping("/tenant/semc/todo")
public class TodoNoticeController {

    @Resource
    TodoNoticeService todoNoticeService;

    /**
     *  三方待办通知
     * @param noticeReq
     * @return
     */
    @Operation(method = "notice",description = "非混合云三方待办通知接口")
    @PostMapping("/notice")
    public ResponseEntity<?> notice(@RequestBody NoticeReq noticeReq) {
        return todoNoticeService.notice(noticeReq);
    }

    /**
     *  三方待办批量通知
     * @param noticeReq
     * @return
     */
    @PostMapping("/noticeBat")
    public ResponseEntity<?> noticeBat(@RequestBody NoticeVO noticeReq) {
        return todoNoticeService.noticeBat(noticeReq);
    }
}
