package com.digiwin.athena.semc.controller.portal;

import com.digiwin.athena.semc.dto.portal.TodoReadReq;
import com.digiwin.athena.semc.service.portal.TodoReadService;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * @author CR-7
 * create: 2024-03-23 17:27
 * Description: 待办已读
 */
@Slf4j
@RestController
@RequestMapping("/semc/todoList/todo")
public class TodoReadController {


    @Resource
    TodoReadService todoReadService;

    /**
     *  保存待办数据
     * @param todoReadReq
     * @return
     */
    @Operation(method = "toRead",description = "保存待办数据")
    @PostMapping("/toRead")
    public ResponseEntity<?> toRead(@RequestBody @Valid TodoReadReq todoReadReq){
        return todoReadService.toRead(todoReadReq);
    }
}
