package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ResultBean;
import com.digiwin.athena.semc.entity.portal.TodosRefreshSet;
import com.digiwin.athena.semc.service.portal.TodosRefreshSetService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @description 三方待办刷新频率管理
 */
@RestController
@RequestMapping("/semc/todo")
public class TodosRefreshSetController {

    private static final Logger logger = LoggerFactory.getLogger(TodosRefreshSetController.class);

    @Resource
    private TodosRefreshSetService todosRefreshSetService;


    /**
     * 三方待办刷新频率保存接口
     *
     * @param req
     * @return
     * @throws Exception
     */
    @PostMapping("/refreshSet")
    public ResultBean refreshSet(@RequestBody TodosRefreshSet req) {
        logger.info("refreshSet param:{},appName:{}", JSON.toJSONString(req));
        ResultBean resultBean = new ResultBean();
        try {
            String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
            req.setTenantId(tenantId);
            String userName = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
            req.setCreateUserId(userName);
            req.setModifyUserId(userName);
            todosRefreshSetService.saveRefreshSet(req);
            return resultBean;
        } catch (Exception e) {
            logger.error("/refreshSet  error req:{},e:{}", JSON.toJSONString(req), e);
            return resultBean;
        }
    }

    /**
     * 三方待办刷新频率查询接口
     * @return
     * @throws Exception
     */
    @PostMapping("/getRefresh")
    public ResultBean getRefresh() {
        ResultBean resultBean = new ResultBean();
        try {
            String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
            if (StringUtils.isEmpty(tenantId)) {
                return resultBean;
            }
            TodosRefreshSet refreshSet = todosRefreshSetService.getRefreshSet(tenantId);
            //没有配置，默认时间
            if (null == refreshSet) {
                refreshSet=new TodosRefreshSet();
                refreshSet.setTabsTime(Constants.TABS_TIME_DEF);
                refreshSet.setTodoDetailTime(Constants.TABS_TIME_DEF);
                refreshSet.setIsOpen(Constants.TABS_IS_OPEN);
            }
            resultBean.setResponse(refreshSet);
            return resultBean;
        } catch (Exception e) {
            logger.error("/getRefresh  error:{}",  e);
            return resultBean;
        }
    }


}
