package com.digiwin.athena.semc.controller.portal;

import com.digiwin.athena.semc.entity.portal.TripartiteApplication;
import com.digiwin.athena.semc.service.portal.TripartiteApplicationService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 三方应用配置controller
 *
 * @author sunqgz
 * @since 2025-08-11
 */
@Slf4j
@RestController
@RequestMapping("/semc/tripartite")
public class TripartiteApplicationController {

    @Resource
    private TripartiteApplicationService tripartiteApplicationService;

    /**
     * 查询三方应用列表
     *
     * @return 查询结果
     */
    @GetMapping("/queryTripartiteAppList")
    public ResponseEntity<?> queryTripartiteAppList() {
        List<TripartiteApplication> tripartiteApplicationList = tripartiteApplicationService.queryTripartiteAppList();
        return ResponseEntityWrapperUtil.wrapperOk(tripartiteApplicationList);
    }
}
