package com.digiwin.athena.semc.controller.portal;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.semc.dto.portal.ActionFunctionResp;
import com.digiwin.athena.semc.service.portal.IUserActionService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import io.swagger.v3.oas.annotations.Operation;

/**
 * @description 用户行为权限
 * @author: sungqz
 * @create: 2023-4-21
 */
@RestController
@RequestMapping("/semc/action")
public class UserActionController {

    private static final Logger logger = LoggerFactory.getLogger(UserActionController.class);

    @Autowired
    IUserActionService userActionService;

    /**
     * 查询用户的行为-功能列表
     *
     * @return ResponseEntity
     */
    @Operation(summary = "查询用户行为对应的功能列表")
    @GetMapping("/function/query")
    public ResponseEntity<BaseResultDTO<List<ActionFunctionResp>>> queryUserActionFunction(@RequestAttribute(value = GlobalConstant.AUTH_USER) AuthoredUser authoredUser) {
        try {
            List<ActionFunctionResp> functionRespList = userActionService.queryUserFunctionList(authoredUser);
            return ResponseEntityWrapperUtil.wrapperOk(functionRespList);
        } catch (Exception e) {
            logger.error("query user action-function error. userId: {}", AppAuthContextHolder.getContext().getAuthoredUser().getUserId(), e);
            return ResponseEntityWrapperUtil.wrapperFail(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage());
        }
    }
}
