package com.digiwin.athena.semc.controller.sso;

import com.digiwin.athena.semc.proxy.iam.service.IamService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/tenant/cas")
public class CasController {

    @Autowired
    private IamService iamService;

    /**
     * 新增sso登录系统的回调地址
     * @param successCallbackUrl
     * @param failCallbackUrl
     * @param logoutCallbackUrl
     * @return
     */
    @GetMapping("/cas-add")
    public ResponseEntity<?>  addCasCallBackUrl(@RequestParam("successCallbackUrl") String successCallbackUrl,
                                                @RequestParam("failCallbackUrl") String failCallbackUrl,
                                                @RequestParam("logoutCallbackUrl") String logoutCallbackUrl){
        return iamService.addCasCallbackUrl(successCallbackUrl,failCallbackUrl,logoutCallbackUrl);
    }
}
