package com.digiwin.athena.semc.controller.sso;

import com.digiwin.athena.semc.common.ResultBean;
import com.digiwin.athena.semc.dto.erpsso.ThirdSsoInfoDto;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.service.sso.IErpSsoInfoService;
import com.digiwin.athena.semc.service.sso.IThirdSsoInfoService;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-10-28 19:40
 **/
@RestController
@RequestMapping("/tenant/open")
public class OpenController {

    @Autowired
    IErpSsoInfoService erpSsoInfoService;

    @Autowired
    IThirdSsoInfoService thirdSsoInfoService;

    @Operation(summary="获取所有稳态配置列表")
    @GetMapping("erpInfoAll")
    public  ResultBean erpAll(){
        ResultBean resultBean = new ResultBean();
        List<ErpSsoInfo> infos = erpSsoInfoService.list();
        resultBean.setResponse(infos);
        return resultBean;
    }

    @Operation(summary="获取所有稳态配置列表后台拼接参数")
    @GetMapping("erpInfoAllWithUrl")
    public  ResultBean erpAllWithUrl(){
        ResultBean resultBean = new ResultBean();
        List<ErpSsoInfo> infos = erpSsoInfoService.erpSsoInfoWithParams();
        List<ThirdSsoInfoDto> infosThirdPartWeb = thirdSsoInfoService.erpSsoInfoWithParams();
        List<Object> resultList = new ArrayList<>();
        resultList.addAll(infos);
        resultList.addAll(infosThirdPartWeb);
        resultBean.setResponse(resultList);
        return resultBean;
    }
}
