package com.digiwin.athena.semc.controller.sso;

import com.digiwin.athena.semc.proxy.iam.service.IamService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author : lzx
 * @date : 2024/5/9 16:26
 */
@RestController
@RequestMapping("/tenant/saml")
public class SamlController {

    @Resource
    private IamService iamService;

    /**
     * 检查SAML回调地址是否存在并添加配置
     *
     * @param successCallbackUrl 成功回调地址
     * @param failCallbackUrl    失败回调地址
     * @return 响应结果
     */
    @GetMapping("/saml-check")
    public ResponseEntity<?> samlAdd(@RequestParam(value = "successCallbackUrl") String successCallbackUrl,
                                     @RequestParam(value = "failCallbackUrl") String failCallbackUrl) {
        return iamService.checkExitAndAddSAMLCallbackUrl(successCallbackUrl, failCallbackUrl);
    }

    /**
     * 更新SAML回调地址
     *
     * @param successCallbackUrl 成功回调地址
     * @param failCallbackUrl    失败回调地址
     * @return 响应结果
     */
    @GetMapping("/saml-add")
    public ResponseEntity<?> addSamlCallbackUrl(@RequestParam(value = "successCallbackUrl") String successCallbackUrl,
                                                @RequestParam(value = "failCallbackUrl") String failCallbackUrl) {
        return iamService.addSamlCallbackUrl(successCallbackUrl, failCallbackUrl);
    }

    /**
     * saml/cas授权码置换userToken  若传ssoType则是cas
     * @param ssoType 是否是cas类型
     * @param authCode 授权码l
     * @return userToken
     */
    @GetMapping("/authCode-login")
    public ResponseEntity<?> authCodeLogin(@RequestParam(value = "authCode") String authCode,@RequestParam(value = "ssoType",required = false) String ssoType) {
        return iamService.queryUserTokenByAuthCode(authCode,ssoType);
    }

}
