package com.digiwin.athena.semc.controller.temp;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.I18NKey;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.ServiceException;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomQueryReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomSaveReq;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustom;
import com.digiwin.athena.semc.service.temp.TemplateSystemCustomService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;

/**
 * @author CR-7
 * create: 2024-01-24 17:04
 * Description: ISV自定义组件
 */
@RestController
@Slf4j
@RequestMapping("/semc/custom/component/temp")
public class TemplateSystemCustomController {


    @Resource
    TemplateSystemCustomService templateSystemCustomService;

    @Resource
    private MessageUtils messageUtils;

    /**
     *  查询自定义组件列表
     * @param labelSystemCustomQueryReq
     * @return
     */
    @Operation(method = "pageQuery",description = "查询自定义组件列表")
    @PostMapping("/pageQuery")
    public ResultPageBean pageQuery(@RequestBody @Valid LabelSystemCustomQueryReq labelSystemCustomQueryReq){
        ResultPageBean resultPageBean;
        try {
            resultPageBean=templateSystemCustomService.pageQuery(labelSystemCustomQueryReq);
        } catch (Exception e) {
            log.error("Query System Custom temp Error",e);
            resultPageBean = ResultPageBean.sysException(new ServiceException(ErrorCodeConstant.LABEL_SYSTEM_CUSTOM,
                    messageUtils.getMessage(I18NKey.SYSTEM_CUSTOM)));
        }
        return resultPageBean;
    }


    /**
     *  保存自定义组件
     * @param labelSystemCustomSaveReq
     * @return
     */
    @Operation(method = "save",description = "保存自定义组件")
    @PostMapping("/save")
    public ResponseEntity<?> save(@RequestBody @Valid LabelSystemCustomSaveReq labelSystemCustomSaveReq){
        try {
           return  templateSystemCustomService.save(labelSystemCustomSaveReq);
        } catch (Exception e) {
            log.error("save system.custom error", e);
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, messageUtils.getMessage(I18NKey.SAVE_SYSTEM_CUSTOM));
        }
    }


    /**
     *  删除自定义组件
     * @param idList
     * @return
     */
    @Operation(method = "delete",description = "删除自定义组件")
    @PostMapping("/delete")
    public ResponseEntity<?> delete(@RequestBody List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, "id cannot be empty");
        }
        try {
           return  templateSystemCustomService.delete(idList);
        } catch (Exception e) {
            log.error("delete system.custom error", e);
            return ResponseEntityWrapper.wrapperFail(ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, messageUtils.getMessage(I18NKey.DELETE_SYSTEM_CUSTOM));
        }
    }

    /**
     *  查询自定义组件
     * @param req
     * @return
     */
    @Operation(method = "queryCustomSystem",description = "查询预设组件和自定义组件列表")
    @PostMapping("/queryCustomSystem")
    public ResponseEntity<BaseResultDTO<List<TemplateSystemCustom>>> queryCustomSystem(@RequestBody LabelSystemAllVo req){
        return ResponseEntityWrapperUtil.wrapperOk(templateSystemCustomService.queryCustomSystem(req));
    }

}
