package com.digiwin.athena.semc.controller.tenant;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.I18NKey;
import com.digiwin.athena.semc.service.tenant.TenantAppService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.tenant.TenantSalesPlanVO;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 租户授权应用控制器
 */
@Slf4j
@RestController
@RequestMapping("/semc/tenant/app")
public class TenantAppController {

    @Resource
    private TenantAppService tenantAppService;

    @Resource
    private MessageUtils messageUtils;

    /**
     * 获取租户授权的销售方案
     * 用于区分不同销售包下，工作台加载的应用方案
     *
     * @return 返回一个响应实体，包含查询结果或错误信息
     */
    @Operation(method = "获取租户授权的销售方案",description = "获取租户授权应用值接口")
    @GetMapping("")
    public ResponseEntity<BaseResultDTO<TenantSalesPlanVO>> queryTenantSalesPlan() {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();

        try {
            return ResponseEntityWrapperUtil.wrapperOk(tenantAppService.queryTenantSalesPlan(tenantId));
        } catch (Exception e) {
            // 当查询过程中发生异常时，记录错误日志，并返回系统错误的响应实体
            log.error("TenantAppController.queryTenantSalesPlan is error, tenantId:{}", tenantId, e);
            return ResponseEntityWrapperUtil.wrapperFail(ErrorCodeConstant.SYSTEM_ERROR, messageUtils.getMessage(I18NKey.COMMON_SYSTEM_ERROR));
        }
    }

}
