package com.digiwin.athena.semc.controller.workbench;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.dto.workbench.req.PortalDeployMessageDto;
import com.digiwin.athena.semc.entity.portal.PortalDeployMessage;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.service.portal.PortalDeployMessageService;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * Created by changcong 21064
 * Date 2025/9/18 8:54
 * Description
 */
@RestController
@RequestMapping("/semc/work-bench/message")
@Slf4j
public class MessageController {

    @Autowired
    private PortalDeployMessageService portalDeployMessageService;

    @Autowired
    private KmService kmService;

    /**
     * 部署门户的消息已读操作
     *
     * @return 响应结果
     */
    @Operation(description = "部署门户的消息已读操作")
    @PostMapping("/readMessage")
    @ResponseBody
    public ResponseEntity<?> readMessageRunning(@RequestBody @Valid PortalDeployMessageDto portalDeployMessageDto) {
        PortalDeployMessage portalDeployMessage = new PortalDeployMessage();
        portalDeployMessage.setPortalId(portalDeployMessageDto.getPortalId());
        portalDeployMessage.setSource(portalDeployMessageDto.getSource());
        portalDeployMessage.setUserSid(AppAuthContextHolder.getContext().getAuthoredUser().getSid());
        portalDeployMessage.setClientType(portalDeployMessageDto.getClientType());
        String version = kmService.queryTenantVersionWithDefault();
        portalDeployMessage.setVersion(version);
        portalDeployMessageService.save(portalDeployMessage);
        return ResponseEntityWrapper.wrapperOk();
    }

}
