package com.digiwin.athena.semc.controller.workbench;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.dto.workbench.req.AppCustomSettingReqDto;
import com.digiwin.athena.semc.dto.workbench.req.WorkBenchDeleteAppReqDto;
import com.digiwin.athena.semc.dto.workbench.req.WorkbenchDeletePortalReqDto;
import com.digiwin.athena.semc.dto.workbench.req.WorkbenchDeployAppReqDto;
import com.digiwin.athena.semc.dto.workbench.req.WorkbenchSwitchAppReqDto;
import com.digiwin.athena.semc.service.workbench.WorkbenchAppService;
import com.digiwin.athena.semc.vo.workbench.AppCustomSettingVO;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import java.util.List;

/**
 * 应用接口操作类
 *
 * @author IPmas
 * @date 2025/8/18
 */
@RestController
@RequestMapping("/semc/work-bench/app")
@Slf4j
public class WorkBenchAppController {
    @Autowired
    private WorkbenchAppService workbenchAppService;

    /**
     * 删除工作台应用
     *
     * @param deleteAppReqDto 应用编码
     * @return 响应结果
     */
    @Operation(description = "删除工作台应用")
    @PostMapping("/delete")
    public ResponseEntity<?> getCustomConfig(@RequestBody WorkBenchDeleteAppReqDto deleteAppReqDto) {
        workbenchAppService.deleteApp(deleteAppReqDto.getAppCode());
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 删除门户
     *
     * @param deletePortalReqDto 应用编码、门户id
     * @return 响应结果
     */
    @Operation(description = "删除工作台应用门户")
    @PostMapping("/deletePortal")
    public ResponseEntity<?> deletePortal(@RequestBody WorkbenchDeletePortalReqDto deletePortalReqDto) {
        workbenchAppService.deletePortal(deletePortalReqDto.getApplication(), deletePortalReqDto.getPortalId());
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 发版工作台应用
     *
     * @return 响应结果
     */
    @Operation(description = "发版工作台应用")
    @PostMapping("/deploy")
    @ResponseBody
    public ResponseEntity<?> deployApp(@RequestParam("deployAppReq") String deployAppReq, MultipartFile file) {
        workbenchAppService.deployApp(JSONObject.parseObject(deployAppReq, WorkbenchDeployAppReqDto.class), file);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 发版工作台应用门户
     *
     * @return 响应结果
     */
    @Operation(description = "部署工作台应用门户")
    @PostMapping("/deployPortal")
    @ResponseBody
    public ResponseEntity<?> deployPortal(@RequestParam("deployAppReq") String deployAppReq, MultipartFile file) {
        workbenchAppService.deployApp(JSONObject.parseObject(deployAppReq, WorkbenchDeployAppReqDto.class), file);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 切版工作台应用
     *
     * @return 响应结果
     */
    @Operation(description = "切版工作台应用")
    @PostMapping("/switch")
    @ResponseBody
    public ResponseEntity<?> switchApp(@RequestBody WorkbenchSwitchAppReqDto switchAppReq) {
        workbenchAppService.switchApp(switchAppReq);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 获取工作台应用客制配置
     *
     * @return 响应结果
     */
    @Operation(description = "获取工作台应用客制配置")
    @PostMapping("/custom-setting")
    @ResponseBody
    public ResponseEntity<?> getAppCustomSetting(@RequestBody @Valid AppCustomSettingReqDto appCustomSettingReq) {
        List<AppCustomSettingVO> customSettings = workbenchAppService.getAppCustomSetting(appCustomSettingReq.getApplication());
        return ResponseEntityWrapper.wrapperOk(customSettings);
    }

    /**
     * 运行态部署门户的消息已读操作
     *
     * @return 响应结果
     */
    @Operation(description = "运行态部署门户的消息已读操作")
    @PostMapping("/readMessage")
    @ResponseBody
    public ResponseEntity<?> readMessage(@RequestBody @Valid AppCustomSettingReqDto appCustomSettingReq) {
        List<AppCustomSettingVO> customSettings = workbenchAppService.getAppCustomSetting(appCustomSettingReq.getApplication());
        return ResponseEntityWrapper.wrapperOk(customSettings);
    }

    @GetMapping ("/getPortalsPublished")
    public ResponseEntity<?> getPortalsPublished (
            @RequestParam List<Long> portalIdList,
            @RequestParam String tenantId){
        return ResponseEntityWrapper.wrapperOk(workbenchAppService.getPortalInfos(portalIdList));
    }
}
