package com.digiwin.athena.semc.converter.event;


import com.digiwin.athena.semc.common.enums.EventTypeEnum;
import com.digiwin.athena.semc.entity.event.EventTracking;
import com.digiwin.athena.semc.vo.event.PageQueryEventTrackingVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.util.List;

@Mapper(componentModel = "spring")
public interface EventTrackingConverter {
    @Mapping(target = "userNameAndId", expression = "java(source.getUserName() + '(' + source.getUserId() + ')')")
    @Mapping(target = "eventDesc", expression = "java(com.digiwin.athena.semc.common.enums.EventTypeEnum.getDescByEventId(source.getEventId()))")
    @Mapping(source = "eventId", target = "eventType")
    @Mapping(target = "eventName", expression = "java(com.digiwin.athena.semc.service.event.impl.EventTrackingServiceImpl.splitEventName(source))")
    PageQueryEventTrackingVO toPageQueryEventTrackingVO(EventTracking source);

    List<PageQueryEventTrackingVO> toPageQueryEventTrackingVOList(List<EventTracking> source);

    default Integer eventIdToEventType(String eventId) {
        return EventTypeEnum.getEventTypeByEventId(eventId);
    }
}
