package com.digiwin.athena.semc.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpStatus;

/**
 * 基础结果类
 */
public class BaseResultDTO<T> {
    /**
     * 状态码，如：200
     */
    private Integer status;

    /**
     * 状态码描述，如：OK
     */
    private String statusDescription;

    /**
     * 错误码
     */
    private String code;
    /**
     * 错误码，业务正常时为null
     */
    private String errorCode;

    /**
     * 错误码描述，业务正常时为null
     */
    private Object errorMessage;

    /**
     * 错误类型，不一定有值，如：System/Business/Unexpected，
     */
    private String errorType;

    private T response;

    private Long serverTime;

    private String path;

    private String traceId;

    private Object debugInfo;

    private String description;

    /**
     * 请求是否OK，errorCode不为0 且 status==200，则认为请求OK
     *
     * @return
     */
    @JsonIgnore
    public boolean isOK() {
        if (StringUtils.isNotBlank(errorCode)) {
            return false;
        }

        return null != status && HttpStatus.SC_OK == status;
    }


    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getStatusDescription() {
        return statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public Object getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(Object errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorType() {
        return errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public T getResponse() {
        return response;
    }

    public void setResponse(T response) {
        this.response = response;
    }

    public Long getServerTime() {
        return serverTime;
    }

    public void setServerTime(Long serverTime) {
        this.serverTime = serverTime;
    }

    public Object getDebugInfo() {
        return debugInfo;
    }

    public void setDebugInfo(Object debugInfo) {
        this.debugInfo = debugInfo;
    }

    public String getTraceId() {
        return traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
