package com.digiwin.athena.semc.dto;

import com.digiwin.app.eai.DigiSrvcode;
import com.digiwin.app.service.DWEAIResult;
import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@Data
public class DWEAIResultBean implements Serializable {

    private static final long serialVersionUID = 1L;

    private transient DigiSrvcode digiSrvcode;

    private Map<String, Object> std_data;

    public DWEAIResultBean(DWEAIResult result) {
        String code = result.getCode();
        this.digiSrvcode = DigiSrvcode.success.value().equals(code)?DigiSrvcode.success:DigiSrvcode.failure;
        this.std_data = new HashMap<>();
        Map<String, Object> execution = new HashMap();
        execution.put("code", result.getCode());
        execution.put("sql_code", result.getSqlCode());
        execution.put("description", result.getDescription());
        this.std_data.put("execution", execution);
        this.std_data.put("parameter", result.getParameter());
    }

    public DWEAIResultBean(String code, String sql_code, String description, Map<String, Object> parameter) {
        this.digiSrvcode = DigiSrvcode.success.value().equals(code)?DigiSrvcode.success:DigiSrvcode.failure;
        this.std_data = new HashMap();
        Map<String, Object> execution = new HashMap();
        execution.put("code", code);
        execution.put("sql_code", sql_code);
        execution.put("description", description);
        this.std_data.put("execution", execution);
        this.std_data.put("parameter", parameter);
    }
}
