package com.digiwin.athena.semc.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * Content-Type:application/json; charset=utf-8
 * digi-protocol: raw
 * digi-srvver:  1.0
 * digi-srvcode:  100
 * {
 * "std_data": {
 * "execution": {
 * "description": "錯誤問題描述",
 * "code": "錯誤碼",
 * "sql_code": "資料庫回傳代碼"
 * },
 * "parameter": {
 * "org_type_region": ""
 * }
 * }
 * }
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class EaiResp<T> implements Serializable {

    /**
     * 执行结果代码。0为成功，非0为失败
     */
    public static final String DIGI_SERVEXECUTION_CODE_SUC = "0";
    public static final String DIGI_SERVEXECUTION_CODE_FAI = "1";

    @JsonProperty("std_data")
    private StdData<T> stdData;


    public static <T> EaiResp buildSucc(T data) {
        EaiResp ret = EaiResp.builder().stdData(new StdData<>(data, new Execution(
                 DIGI_SERVEXECUTION_CODE_SUC, "成功", ""
        ))).build();
        return ret;
    }

    public static <T> EaiResp buildError(String errCode, String errMsg) {
        EaiResp ret = EaiResp.builder().stdData(new StdData<>(null, new Execution(
                errCode, errMsg, "")
        )).build();
        return ret;
    }

    public static <T> EaiResp buildError(String errMsg) {
        EaiResp ret = EaiResp.builder().stdData(new StdData<>(null, new Execution(
                 DIGI_SERVEXECUTION_CODE_FAI, errMsg, "")
        )).build();
        return ret;
    }

    public static <T> EaiResp buildError(String code, String sql_code, String description) {
        EaiResp ret = EaiResp.builder().stdData(new StdData<>(null, new Execution(
                code, description, sql_code)
        )).build();
        return ret;
    }


}
