package com.digiwin.athena.semc.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

@Data
public class PageInfo implements Serializable {
    private static final long serialVersionUID = 3949923069483970612L;

    // 是否有下一页
    private boolean hasNext;

    // 当前页码
    private Integer pageNo;

    // 分页大小
    private Integer pageSize;

    // 总页数
    private Integer pageCount;

    // 记录总数
    private Integer totalResults;

    private PageInfo(Integer pageNo, Integer pageSize, Integer totalResults) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        if (Objects.nonNull(totalResults)) {
            this.totalResults = totalResults;
            this.pageCount = totalResults % pageSize == 0 ? totalResults / pageSize : totalResults / pageSize + 1;
            this.hasNext = !Objects.equals(pageNo, this.pageCount);
        }
    }

    /**
     * 获取默认分页对象
     *
     * @param totalResults 记录总数
     * @return 分页对象
     */
    public static PageInfo getDefaultPageInfo(Integer totalResults) {
        return new PageInfo(1, 50, totalResults);
    }

    /**
     * 获取指定分页对象
     *
     * @param pageNo       当前页码
     * @param pageSize     分页大小
     * @param totalResults 记录总数
     * @return 分页对象
     */
    public static PageInfo getPageInfo(Integer pageNo, Integer pageSize, Integer totalResults) {
        return new PageInfo(pageNo, pageSize, totalResults);
    }

    /**
     * 获取指定分页对象
     *
     * @param pageNo   当前页码
     * @param pageSize 分页大小
     * @return 分页对象
     */
    public static PageInfo getPageInfo(Integer pageNo, Integer pageSize) {
        return new PageInfo(pageNo, pageSize, null);
    }
}
