package com.digiwin.athena.semc.dto.common;

import lombok.*;

import java.io.Serializable;
import java.util.List;

/**
 * 翻译接口入参
 *
 * @author sunqgz
 * @since 2024-06-26
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class TranslateReq implements Serializable {

    private static final long serialVersionUID = -1505176608804006104L;

    /**
     * 文本
     */
    private String content;

    /**
     * 转换类型数组，eg:["zh2Hant","zh2Hans "] （中转繁 ：zh2Hant，繁转简 ：zh2Hans ）
     */
    private List<String> convertTypes;
}