package com.digiwin.athena.semc.dto.config;

import java.io.Serializable;
import java.util.List;

import lombok.Data;


/**
 * 移动端门户缓存配置参数
 */
@Data
public class MobilePortalCacheConfigParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * all（全部走缓存），否则根据配置租户走缓存
     */
    private List<String> tenantList;


    /**
     * 缓存失效时间
     */
    private Integer expiredTime;


    /**
     * 0秒，1分，2小时，3天
     */
    private Integer expiredTimeDuration;

    /**
     * 异步获取数据时间
     */
    private Integer asyncFetchDataTime;

    /**
     * 0秒，1分，2小时，3天
     */
    private Integer asyncFetchDataTimeDuration;

    /**
     * 特定门户缓存策略
     */
    private List<ExpandTimePortal> expandTimePortal;


    @Data
    public static class ExpandTimePortal implements Serializable {

        private static final long serialVersionUID = 1L;

        /**
         * 需要延迟异步获取数据时间的门户
         */
        private String portalId;

        /**
         * 迟异步获取数据时间
         */
        private Integer asyncFetchDataTime;

        /**
         * 0秒，1分，2小时，3天
         */
        private Integer asyncFetchDataTimeDuration;
    }

}
