package com.digiwin.athena.semc.dto.device;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.*;

import java.io.Serializable;

/**
 * @Author jf gui
 * @Description   设备绑定导出信息
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class DeviceBindExportVO implements Serializable {

    @ColumnWidth(20)
    @ExcelProperty(index = 0, value = "{Athena.Account}")
    private String userId;

    @ColumnWidth(15)
    @ExcelProperty(index = 1, value = "{Device.terminal.Type}")
    private String terminalType;

    @ColumnWidth(40)
    @ExcelProperty(index = 2, value = "{Device.Id}")
    private String deviceId;


    public DeviceBindExportVO(DeviceBindRecordVO device){
        this.deviceId =device.getDeviceId();
        this.terminalType = device.getTerminalType()==1?"APP":"PC";
        this.userId = device.getUserId();
    }
}