package com.digiwin.athena.semc.dto.device;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.NumberFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.digiwin.athena.semc.common.Constants;
import lombok.*;

import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @Description
 * @Author cai chao
 * @Date 2025/7/22 15:51
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class DeviceBindImportTemplateVo {

    @ColumnWidth(20)
    @ExcelProperty(index = 0, value = "雅典娜账号")
    @NotBlank(message = "{Athena.Account}{Not.exist}")
    @Size(max = 100, message = "{Athena.Account}{LengthMax}")
    private String userId;

    @ColumnWidth(20)
    @ExcelProperty(index = 1, value = "设备终端类型")
    @NotNull(message = "{Device.terminal.Type}{Required}")
    private String terminalType;

    @ColumnWidth(20)
    @ExcelProperty(index = 2, value = "设备地址")
    @NotBlank(message = "{Device.Id}{Required}")
    @Size(max = 100, message = "{Device.Id}{LengthMax}")
    @NumberFormat(value = "0")
    private String deviceId;

    @ColumnWidth(100)
    @ExcelProperty(index = 3, value = "失败原因")
    private String failMsg;

    /**
     * 用户名
     */
    @ExcelIgnore
    private String userName;

    @AssertTrue(message = "{Device.TerminalType.Not.Match}")
    public boolean isTerminalTypeValid() {
        return Constants.TerminalTypeEnum.getCodes().contains(terminalType);
    }

    public DeviceBindImportTemplateVo trim() {
        if (StrUtil.isNotBlank(userId)) {
            this.userId = userId.trim();
        }
        if (StrUtil.isNotBlank(terminalType)) {
            this.terminalType = terminalType.trim();
        }
        if (StrUtil.isNotBlank(deviceId)) {
            this.deviceId = deviceId.trim();
        }
        return this;
    }
}
