package com.digiwin.athena.semc.dto.device;

import lombok.Data;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @Author jf gui
 * @Description 设备绑定查询数据传输对象
 */
@Data
public class DeviceBindQueryDTO {

    /**
     * 设备唯一标识
     */
    private String deviceId;

    /**
     * 设备名称
     */
    private String deviceName;

    /**
     * 终端类型 0-PC 1-移动
     */
    private Integer terminalType;

    /**
     * 绑定账户
     */
    private String userId;

    /**
     * 有效状态，0 有效，1 无效
     */
    private Integer status;

    /**
     * 页码，必填
     */
    @NotNull(message = "页码不能为空")
    @Min(value = 1, message = "页码不能小于1")
    private Integer pageNum;

    /**
     * 每页数量，必填
     */
    @NotNull(message = "每页数量不能为空")
    @Min(value = 1, message = "每页数量不能小于1")
    private Integer pageSize;
}    