package com.digiwin.athena.semc.dto.device;

import com.digiwin.athena.semc.entity.device.DeviceInfo;
import com.digiwin.athena.semc.entity.device.UserBindDevice;
import lombok.Data;

import java.util.Date;

/**
 * @Author jf gui
 * @Description 设备绑定记录返回对象
 */
@Data
public class DeviceBindRecordVO {

    /**
     * 主键
     */
    private String id;

    /**
     * 设备唯一标识
     */
    private String deviceId;

    /**
     * 设备名称
     */
    private String deviceName;

    /**
     * 终端类型 0-PC 1-移动
     */
    private Integer terminalType;

    /**
     * 绑定账户
     */
    private String userId;

    /**
     * 绑定账号名称
     */
    private String userName;

    /**
     * 租户
     */
    private String tenantId;

    /**
     * 有效状态，0 有效，1 无效
     */
    private Integer status;

    /**
     * 创建用户ID
     */
    private String createUserId;

    /**
     * 创建用户名
     */
    private String createUserName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改用户名
     */
    private String modifyUserName;

    /**
     * 修改时间
     */
    private String modifyTime;

    /**
     * 修改用户ID
     */
    private String modifyUserId;


    public static DeviceBindRecordVO build(UserBindDevice userBindDevice, DeviceInfo deviceInfo) {
        DeviceBindRecordVO deviceBindRecordVO = new DeviceBindRecordVO();
        deviceBindRecordVO.setId(userBindDevice.getId().toString());
        deviceBindRecordVO.setDeviceId(deviceInfo.getDeviceId());
        deviceBindRecordVO.setDeviceName(deviceInfo.getDeviceName());
        deviceBindRecordVO.setTerminalType(deviceInfo.getTerminalType());
        deviceBindRecordVO.setUserId(userBindDevice.getUserId());
        deviceBindRecordVO.setUserName(userBindDevice.getUserName());
        deviceBindRecordVO.setStatus(userBindDevice.getStatus());
        deviceBindRecordVO.setCreateUserId(userBindDevice.getCreateUserId());
        deviceBindRecordVO.setCreateUserName(userBindDevice.getCreateUserName());
        deviceBindRecordVO.setModifyTime(userBindDevice.getModifyTime());
        deviceBindRecordVO.setModifyUserId(userBindDevice.getModifyUserId());
        deviceBindRecordVO.setTenantId(userBindDevice.getTenantId());
        return deviceBindRecordVO;
    }
}    