package com.digiwin.athena.semc.dto.device;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @Author jf gui
 * @Description 设备绑定添加入参实体
 */
@Data
public class DeviceBindSaveDTO {

    /**
     * 设备唯一标识
     */
    @NotBlank(message = "{Device.Id}{Required}")
    @Size(max = 100, message = "{Device.Id}{LengthMax}")
    private String deviceId;

    /**
     * 终端类型 0-PC 1-移动
     */
    @NotNull(message = "{Device.terminal.Type}{Required}")
    @Max(value = 1, message = "{Device.TerminalType.Not.Match}")
    private Integer terminalType;

    /**
     * 绑定账户
     */
    @NotBlank(message = "{Athena.Account}{Not.exist}")
    @Size(max = 100, message = "{Athena.Account}{LengthMax}")
    private String userId;

    /**
     * 绑定账户
     */
    private String userName;

    /**
     * 有效状态，0 有效，1 无效
     */
    private Integer status = 0;
}    