package com.digiwin.athena.semc.dto.device;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;


/**
 * @Author jeff gui
 * @Description 设备信息表实体
 *
 */
@Data
public class DeviceDTO {
    /**
     * 设备ID
     */
    @NotBlank(message = "{Device.Id}{Required}")
    @Size(max = 100, message = "{Device.Id}{LengthMax}")
    private String deviceId;

    /**
     * 上报设备名称
     */
    @NotBlank(message = "{Device.Name}{Required}")
    @Size(max = 255, message = "{Device.Id}{LengthMax}")
    private String deviceName;

    /**
     * 上报终端类型 0:PC端 1：移动端
     */
    @NotNull(message = "{Device.terminal.Type}{Required}")
    @Max(value=1,message = "{Device.TerminalType.Not.Match}")
    private Integer terminalType;

    /**
     * 设备型号
     */
    @NotBlank(message = "{Device.Model}{Required}")
    @Size(max = 255, message = "{Device.Model}{LengthMax}")
    private String deviceModel;

    /**
     * 硬件UUID
     */
    private String hardwareUuid;

    /**
     * MAC地址
     */
    private String macAddress;

    /**
     * 操作系统类型 Windows, macOS, Linux, iOS, Android, Other
     */
    private String osType;

}