package com.digiwin.athena.semc.dto.erpsso;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @program: codes
 * @description: 新增稳态配置 请求参数
 * @author: sungq
 * @create: 2022-11-21
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class AddSsoInfoReq implements Serializable {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 应用sid
     */
    private Long appSid;

    /**
     * 应用code
     */
    @NotBlank(message = "应用code不能为空")
    private String code;

    /**
     * 应用名称
     */
    @NotBlank(message = "应用名称不能为空")
    @Size(min = 1, max = 30, message = "应用名称的长度不能超过30")
    private String name;

    /**
     * 应该描述
     */
    private String desc;

    /**
     * 客户端方式 1:直接指定路径 2:自定义协议头
     */
    @NotNull(message = "客户端方式不能为空")
    @Range(min = 1, max = 2, message = "客户端方式不合法")
    private Integer locationType;

    /**
     * 协议头 客户端地址前缀
     */
    @NotBlank(message = "协议头不能为空")
    @Size(min = 1, max = 200, message = "协议头长度不能超过200")
    private String prefix;

    /**
     * 稳态客户端配置
     */
    @Size(max = 200, message = "稳态客户端配置长度不能超过200")
    private String clientLocation;

    /**
     * 是否base64加密 1:否 2:是
     */
    @Schema(title = "是否使用base64加密参数")
    @Range(min = 1, max = 2, message = "base64Encode is illegal")
    private Integer base64Encode;

    /**
     * appToken
     */
    @Size(max = 200, message = "appToken的长度不能超过200")
    private String appToken;

    /**
     * 应用id
     */
    private String appId;

    /**
     * 应用秘钥
     */
    private String appSecret;

    private Integer protocolType;

    private String casServerUrl;

    /**
     * 归户模式 0:自动归户 1：手动归户 2：无需归户 3：外链模式
     */
    @Range(max = 3, message = "归户模式不合法")
    private Integer userBindFlag;

    /**
     * 动态参数
     */
    @Size(max = 1000, message = "动态参数的长度不能超过1000")
    private String ext;
}
