package com.digiwin.athena.semc.dto.erpsso;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @program: codes
 * @description: 授权信息
 * @author: lisheng
 * @create: 2024-5-10
 *
 * {
 *         "code": "3867ca81f69b4637a0b834be5a7b2f05",
 *         "userSid": 189515721536064,
 *         "scopes": [
 *             "user_read"
 *         ],
 *         "tenantSid": 258964363424320,
 *         "tenantId": "athenaPaasW"
 *     }
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class AuthorizeDTO implements Serializable {

    /**
     * 授权码
     */
    private String code;

    /**
     * 用户sid
     */
    private String userSid;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 租户sid
     */
    private long tenantSid;

    private List<String> scopes;
}