package com.digiwin.athena.semc.dto.erpsso;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * @program: codes
 * @description: 查询SSO url 接口入参
 * @author: lisheng
 * @create: 2024-12-09
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class GetSsoUrlReq implements Serializable {

    /**
     * 目前支持ksd-知识中台的智能文檔
     */
    private String ssoAppCode;

    /**
     * 是否需要免登
     */
    private Boolean ssoLogin;

    /**
     * 应用类型 1:b/s应用 2:c/s应用 3:特殊应用 4:IAM应用 5:虚拟应用
     */
    private String appType;

    /**
     * 动态参数 key:routerLink
     */
    private Map<String,String> dynamicParams;

    /**
     * 手动-manual，预置-prepare add by 41394
     */
    private String ssoSourceType;
}
