package com.digiwin.athena.semc.dto.erpsso;

import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Description: 更新标识 是否显示在友情链接
 * @CreateTime: 2023/5/30
 * @Author: sungqz
 */
@Data
public class PreApplicationUpdateDto {
    /**
     * 预装应用id
     */
    @NotEmpty(message = "预装应用id列表不能为空")
    private List<Long> preApplicationIdList;

    /**
     * 是否显示在友情链接 0：否 1：是
     */
    @NotNull(message = "是否显示标识不能为空")
    @Range(min = 0, max = 1, message = "是否显示标识的值不合法")
    private Integer linkDisplayFlag;

}
