package com.digiwin.athena.semc.dto.erpsso;

import lombok.Data;

import java.io.Serializable;

/**
 * @description: 预设的C/S配置字段
 * @author: sungqz
 * @create: 2023-1-31
 **/
@Data
public class PreErpSsoDTO implements Serializable {

    /**
     * 应用code
     */
    private String applicationCode;

    /**
     * 应用名称
     */
    private String applicationName;

    /**
     * 应用描述
     */
    private String applicationDescription;

    /**
     * 客户端方式 1:直接指定路径 2:自定义协议头
     */
    private Integer getClientMode;

    /**
     * 协议头 客户端地址前缀
     */
    private String protocolHeader;

    /**
     * 稳态客户端配置
     */
    private String clientConfiguration;

    /**
     * 是否base64加密 0:否 1:是
     */
    private Integer paramEncryptionMethod;

    /**
     * appToken
     */
    private String appToken;

    /**
     * appId
     */
    private String appId;

    /**
     * 动态参数
     */
    private String dynamicParameter;
}
