package com.digiwin.athena.semc.dto.erpsso;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Range;

import java.io.Serializable;

/**
 * @program: codes
 * @description: 查询应用列表过滤条件
 * @author: sungq
 * @create: 2024-03-14
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class QueryAppListReq implements Serializable {

    private static final long serialVersionUID = -1391567936094582752L;

    /**
     * 过滤类型 message：异构消息新增应用
     */
    @Range(max = 1, message = "the filterType is illegal")
    private String filterType;


    /**
     * 是否需要鼎捷雅典娜app应用，0：不需要，1：需要
     */
    private Integer  isNeedApp;
}
