package com.digiwin.athena.semc.dto.erpsso;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * @program: codes
 * @description: 查询应用过滤条件
 * @author: lisheng
 * @create: 2024-05-10
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class QueryDisplayReq implements Serializable {

    private static final long serialVersionUID = -1391567936094582733L;

    /**
     * erp客户端产品name:目前只支持WFGP
     */
    private String erpAppName;

    /**
     * 动态参数
     *
     * 对应WFGP的报表id字段
     * {PRID: code}
     * 对应云端运营单元
     * {CompanyIDai: eocCompanyId}
     */
    private Map<String,String> dynamicParams;
}
