package com.digiwin.athena.semc.dto.erpsso;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @program: codes
 * @description: 设置归户关系 请求实体
 * @author: sungq
 * @create: 2023-5-8
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SsoBindReq implements Serializable {

    /**
     * 配置主键id列表
     */
    private List<Long> idList;

    /**
     * 归户模式 0:自动归户 1：手动归户 2：无需归户
     */
    private Integer bindFlag;

    /**
     * 应用的类型 1：B/S配置 2：C/S配置 3：预设应用
     */
    private Integer appType;
}
