package com.digiwin.athena.semc.dto.erpsso;

import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * @description: 第三方web配置表Dto
 * @author: jianglpc
 * @create: 2022-11-28
 **/
@Data
@AutoMapper(target = ThirdSsoInfo.class)
public class ThirdSsoInfoDto implements Serializable {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 应用code
     */
    private String appCode;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 应用描述
     */
    private String appDesc;


    /**
     * 授权回调地址
     */
    private String callBackUrl;

    /**
     * logo回调地址
     */
    private String logoBackUrl;

    /**
     * appToken
     */
    private String appToken;

    /**
     * 应用id
     */
    private String appId;

    /**
     * 应用秘钥
     */
    private String appSecret;

    /**
     * 归户模式 0:自动归户 1：手动归户 2：无需归户
     */
    private Integer userBindFlag;

    /**
     * 有效状态 0:无效 1:有效
     */
    private Integer validStatus;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 扩展字段
     */
    private String extend;

    /**
     * 用于存放编码
     */
    private String code;

    /**
     * 用于存放链接
     */
    private Map<String, Object> ext;

    /**
     * 应用名称-返回前台
     */
    private String name;

    private Integer protocolType;

    private String casServerUrl;
}
