package com.digiwin.athena.semc.dto.event;


import java.io.Serializable;
import java.util.List;
import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * 埋点请求入参
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
@Builder
public class EventTrackingReq implements Serializable {
    private static final long serialVersionUID = 2128817326090501511L;

    /**
     * 事件时间
     */
    private String ts;

    /**
     * 公共属性
     */
    private Map<String, Object> common;

    /**
     * 用户属性
     */
    private UserDTO user;

    /**
     * 事件列表
     */
    private List<EventsDTO> events;

    @Data
    public static class UserDTO {
        /**
         * 用户id
         */
        private String userId;

        /**
         * 用户名称
         */
        private String userName;

        /**
         * 租户id
         */
        private String tenantId;

        /**
         * 租户名称
         */
        private String tenantName;
    }

    @Data
    public static class EventsDTO {
        /**
         * 事件id
         */
        private String eventCode;

        /**
         * 事件属性
         */
        private List<Map<String,Object>> attrs;

        /**
         * 页面信息
         */
        private Map<String,Object> page;
    }
}
