package com.digiwin.athena.semc.dto.fineReport;

import lombok.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 新增/修改租户的帆软参数配置
 *
 * @author sunqgz
 * @since 2025-08-11
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class FineReportConfigDTO implements Serializable {

    private static final long serialVersionUID = 2938621469132089762L;

    /**
     * 应用id
     */
    @NotBlank(message = "the clientId cannot be null")
    @Size(max = 100, message = "The length of the templateName cannot exceed 100")
    private String clientId;

    /**
     * 应用密钥
     */
    @NotBlank(message = "the secret cannot be null")
    @Size(max = 100, message = "The length of the templateName cannot exceed 100")
    private String secret;

    /**
     * 帆软后台单点登录publicKey
     */
    @Size(max = 1000, message = "The length of the templateName cannot exceed 1000")
    private String publicKey;

    /**
     * 是否开启【ssoToken超时设置】 false：否 true：是
     */
    private Boolean tokenTimeoutFlag;
}